<?php
/****************************************
 * XKLog 前台管理页
 *
 * 此文件控制输出前台管理页
 *
 * 更新：2009-06-13
 * 版本：V1.0
 ****************************************/

require('./include/loader.php');
require('./editor/fckeditor.php');
require('./function/fun_data.php');
require('./function/fun_page.php');

@header('content-Type: text/html; charset=utf-8');

if( !user_is_admin() ){
	show_message( '您不是前台管理员，不能访问此页。' ,get_http_referer() );
	exit;
}

$_ENV['title'] = '管理';

// 参数处理
$action = getGP( 'do', 'G' );
$id = getGP( 'id', 'G', 'int' );

// 加载用户自定义函数
$fun_file = XKLOG_ROOT . './style/' . $_CACHE['set'][0]['Style'] . '/function.php';
if ( file_exists( $fun_file ) ) {
	include_once( $fun_file );
}
unset( $fun_file );

switch( $action )
{
	case 'saveadd':
		// 执行保存日志
		$article_id = data_article_add();
		$article_type = getGP('article_type','P');
		if( $article_type != '动态' ){
			page_make( $article_id, $article_type );
		}
		cache_count();
		cache_article_new();
		show_message( '日志添加成功', 'index.php' );
		break;
	case 'saveedit':
		// 执行修改日志
		data_article_edit( $id );
		$article_type = getGP('article_type','P');
		if( $article_type != '动态' ){
			page_make( $id, $article_type );
		}
		cache_article_new();
		cache_article_hot();
		show_message( '日志修改成功', 'index.php' );
		break;
	case 'top':
		// 执行日志置顶
		$db->query( "UPDATE `" . PREFIX_STR . "Article` SET IsTop = 1 WHERE ID=$id" );
		show_message( '日志置顶成功', get_http_referer() );
		break;
	case 'topcancel':
		// 执行取消日志置顶
		$db->query( "UPDATE `" . PREFIX_STR . "Article` SET IsTop = 0 WHERE ID=$id" );
		show_message( '取消日志置顶成功', get_http_referer() );
		break;
	case 'reflash':
		// 执行刷新日志
		page_make_html( $id );
		$db->query( "UPDATE `" . PREFIX_STR . "Article` SET `Update`=0 where ID=$id" );
		show_message( '刷新日志成功', get_http_referer() );
		break;
	case 'del':
		// 执行删除日志
		$category = $db->result( "SELECT Category FROM `" . PREFIX_STR . "Article` WHERE ID=$id AND IsDel = 0" );
		if( $category == '' ) {
			show_message( '日志不存在！' );
			exit;
		}
		// 分类计数
		$db->query( "UPDATE `" . PREFIX_STR . "Category` SET ArticleNum = ArticleNum - 1 WHERE CID=$category" );
		// 删除此日志的评论
		$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET IsDel = 1 WHERE ArticleID=$id" );
		// 删除日志
		$db->query( "UPDATE `" . PREFIX_STR . "Article` SET IsDel = 1 WHERE ID=$id" );
		// 刷新缓存
		cache_article_new();
		cache_article_hot();
		cache_comment_new();
		cache_category();
		cache_count();
		show_message( '删除日志成功' );
		break;
	case 'addreply':
		// 执行添加回复
		$reply = htmlspecialchars( getGP('CommentReply','P') );
		$reply = str_replace( array("\r\n", "\n", "\r"), '<br />', $reply );
		$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET ReplyUser = '" . $_CACHE['user']['user_name'] . "',Reply = '$reply',ReplyTime = " . PHP_TIME . " WHERE CID = $id" );
		show_message( '添加回复成功', get_http_referer() );
		break;
	case 'delreply':
		// 执行删除回复
		$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET ReplyUser = NULL WHERE CID = $id" );
		show_message( '删除回复成功' );
		break;
	case 'delcomment':
		// 执行删除评论
		$aid = $db->result( "SELECT ArticleID FROM `" . PREFIX_STR . "Comment` WHERE CID=$id AND IsDel = 0" );
		if( $aid == '' ) {
			show_message( '评论不存在！' );
			exit;
		}
		$db->query( "UPDATE `" . PREFIX_STR . "Article` SET Comment = Comment - 1 WHERE ID=$aid" );
		$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET IsDel = 1 WHERE CID=$id" );
		cache_article_hot();
		cache_comment_new();
		cache_guestbook_new();
		cache_count();
		show_message( '删除评论成功' );
		break;
	case 'censor':
		// 评论审核通过
		$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET IsShow = 1 WHERE CID = $id" );
		cache_comment_new();
		cache_guestbook_new();
		show_message( '审核评论成功', get_http_referer() );
		break;
	case 'edit':
		// 输出日志编辑页
		$_ENV['article'] = $db->fetch_one_array( 'select * from `' . PREFIX_STR . 'Article` where ID=' . $id );
		$_ENV['article']['Trackback'] = '';//$db->result( 'select TB_URL from `' . PREFIX_STR . 'Trackback` where TB_Type = 0 AND TB_Article_ID=' . $id );
		$_ENV['article']['Tag'] = str_replace( '*}{*',',',$_ENV['article']['Tag']);
		$_ENV['article']['Tag'] = str_replace( '*}','',$_ENV['article']['Tag']);
		$_ENV['article']['Tag'] = str_replace( '{*','',$_ENV['article']['Tag']);
		$temp = array();
		$temp = split( ',' , $_ENV['article']['Tag']);
		$_ENV['article']['Tag'] = '';
		foreach($temp as $row){
			if( isset( $_CACHE['tag'][$row]['T_Name'] ) ){
				$_ENV['article']['Tag'] .= '{*' . $_CACHE['tag'][$row]['T_Name'] . '*}';
			}
		}
		$_ENV['article']['Tag'] = str_replace( '*}{*',',',$_ENV['article']['Tag']);
		$_ENV['article']['Tag'] = str_replace( '*}','',$_ENV['article']['Tag']);
		$_ENV['article']['Tag'] = str_replace( '{*','',$_ENV['article']['Tag']);
		$_ENV['article']['do'] = 'do=saveedit&id=' . $id;
		template('admin');
		break;
	default:
		// 输出日志添加页
		$temp = array('Title','Content','Summary','Category','Tag','Trackback','Address','KeyWords','Description');
		foreach ( $temp as $value ) {
			$_ENV['article'][$value] = '';
		}
		$_ENV['article']['Trackback'] = '此功能尚未完成';
		$_ENV['article']['Type'] = $_CACHE['set'][0]['ArtType'];
		$_ENV['article']['do'] = 'do=saveadd';
		template('admin');
}
?>